from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.mqqueue.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MQQueue');

  containmentpath = "%(parentconpath)sMQQueue:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MQQueue')

  name = Util.getRequiredAttribute(objid, "name", 'MQQueue');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMQQueue");
  exportedObject.put("roleName", "WebSphereMQQueue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.mqmdreadenabled", objid, "mqmdReadEnabled","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.queuemanagerport", objid, "queueManagerPort","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.password", objid, "password","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.readahead", objid, "readAhead","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.specifiedexpiry", objid, "specifiedExpiry","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.queuemanagerhost", objid, "queueManagerHost","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.receiveconvert", objid, "receiveConvert","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.basequeuename", objid, "baseQueueName","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.basequeuemanagername", objid, "baseQueueManagerName","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.providertype", objid, "providerType","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.decimalencoding", objid, "decimalEncoding","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.serverconnectionchannelname", objid, "serverConnectionChannelName","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.expiry", objid, "expiry","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.sendasync", objid, "sendAsync","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.username", objid, "userName","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.integerencoding", objid, "integerEncoding","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.mqmdwriteenabled", objid, "mqmdWriteEnabled","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.mqmdmessagecontext", objid, "mqmdMessageContext","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.specifiedpriority", objid, "specifiedPriority","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.jndiname", objid, "jndiName","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.ccsid", objid, "CCSID","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.category", objid, "category","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.description", objid, "description","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.usenativeencoding", objid, "useNativeEncoding","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.messagebody", objid, "messageBody","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.targetclient", objid, "targetClient","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.receiveccsid", objid, "receiveCCSID","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.priority", objid, "priority","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.persistence", objid, "persistence","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.floatingpointencoding", objid, "floatingPointEncoding","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.replytostyle", objid, "replyToStyle","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.readaheadclose", objid, "readAheadClose","MQQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueue.name", objid, "name","MQQueue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MQQueue');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MQQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.mqqueue.name"):
    raise Exception("Resource role properties does not contain websphere.mqqueue.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create MQQueue on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MQQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqqueue.name"):
    raise Exception("Resource role properties does not contain websphere.mqqueue.name!");

  properties = [];
  Util.addIfNotNone(properties, "mqmdReadEnabled", roleProperties.optString("websphere.mqqueue.mqmdreadenabled", "false"));
  Util.addIfNotNone(properties, "queueManagerPort", roleProperties.optString("websphere.mqqueue.queuemanagerport", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.mqqueue.password", None));
  Util.addIfNotNone(properties, "readAhead", roleProperties.optString("websphere.mqqueue.readahead", None));
  Util.addIfNotNone(properties, "specifiedExpiry", roleProperties.optString("websphere.mqqueue.specifiedexpiry", None));
  Util.addIfNotNone(properties, "queueManagerHost", roleProperties.optString("websphere.mqqueue.queuemanagerhost", None));
  Util.addIfNotNone(properties, "receiveConvert", roleProperties.optString("websphere.mqqueue.receiveconvert", "QMGR"));
  Util.addIfNotNone(properties, "baseQueueName", roleProperties.optString("websphere.mqqueue.basequeuename", None));
  Util.addIfNotNone(properties, "baseQueueManagerName", roleProperties.optString("websphere.mqqueue.basequeuemanagername", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.mqqueue.providertype", None));
  Util.addIfNotNone(properties, "decimalEncoding", roleProperties.optString("websphere.mqqueue.decimalencoding", None));
  Util.addIfNotNone(properties, "serverConnectionChannelName", roleProperties.optString("websphere.mqqueue.serverconnectionchannelname", None));
  Util.addIfNotNone(properties, "expiry", roleProperties.optString("websphere.mqqueue.expiry", None));
  Util.addIfNotNone(properties, "sendAsync", roleProperties.optString("websphere.mqqueue.sendasync", None));
  Util.addIfNotNone(properties, "userName", roleProperties.optString("websphere.mqqueue.username", None));
  Util.addIfNotNone(properties, "integerEncoding", roleProperties.optString("websphere.mqqueue.integerencoding", None));
  Util.addIfNotNone(properties, "mqmdWriteEnabled", roleProperties.optString("websphere.mqqueue.mqmdwriteenabled", "false"));
  Util.addIfNotNone(properties, "mqmdMessageContext", roleProperties.optString("websphere.mqqueue.mqmdmessagecontext", "DEFAULT"));
  Util.addIfNotNone(properties, "specifiedPriority", roleProperties.optString("websphere.mqqueue.specifiedpriority", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.mqqueue.jndiname", None));
  ccsid = roleProperties.optString("websphere.mqqueue.ccsid", None);
  if ccsid is not None and ccsid != "0":
    Util.addIfNotNone(properties, "CCSID", ccsid);
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.mqqueue.category", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.mqqueue.description", None));
  Util.addIfNotNone(properties, "useNativeEncoding", roleProperties.optString("websphere.mqqueue.usenativeencoding", None));
  Util.addIfNotNone(properties, "messageBody", roleProperties.optString("websphere.mqqueue.messagebody", "UNSPECIFIED"));
  Util.addIfNotNone(properties, "targetClient", roleProperties.optString("websphere.mqqueue.targetclient", None));
  Util.addIfNotNone(properties, "receiveCCSID", roleProperties.optString("websphere.mqqueue.receiveccsid", "1208"));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.mqqueue.priority", None));
  Util.addIfNotNone(properties, "persistence", roleProperties.optString("websphere.mqqueue.persistence", None));
  Util.addIfNotNone(properties, "floatingPointEncoding", roleProperties.optString("websphere.mqqueue.floatingpointencoding", None));
  Util.addIfNotNone(properties, "replyToStyle", roleProperties.optString("websphere.mqqueue.replytostyle", "DEFAULT"));
  Util.addIfNotNone(properties, "readAheadClose", roleProperties.optString("websphere.mqqueue.readaheadclose", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.mqqueue.name", None));
  print "Creating MQQueue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MQQueue", parentid, properties);
  Util.popPathElement('MQQueue');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MQQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqqueue.name"):
    raise Exception("Resource role properties does not contain websphere.mqqueue.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.mqmdreadenabled", "false"), "mqmdReadEnabled","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.queuemanagerport", None), "queueManagerPort","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.password", None), "password","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.readahead", None), "readAhead","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.specifiedexpiry", None), "specifiedExpiry","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.queuemanagerhost", None), "queueManagerHost","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.receiveconvert", "QMGR"), "receiveConvert","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.basequeuename", None), "baseQueueName","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.basequeuemanagername", None), "baseQueueManagerName","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.providertype", None), "providerType","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.decimalencoding", None), "decimalEncoding","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.serverconnectionchannelname", None), "serverConnectionChannelName","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.expiry", None), "expiry","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.sendasync", None), "sendAsync","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.username", None), "userName","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.integerencoding", None), "integerEncoding","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.mqmdwriteenabled", "false"), "mqmdWriteEnabled","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.mqmdmessagecontext", "DEFAULT"), "mqmdMessageContext","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.specifiedpriority", None), "specifiedPriority","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.jndiname", None), "jndiName","MQQueue");
  ccsid = roleProperties.optString("websphere.mqqueue.ccsid", None);
  if ccsid is not None and ccsid != "0":
    Util.addAttIfChanged(objid, atts, ccsid, "CCSID","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.category", None), "category","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.description", None), "description","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.usenativeencoding", None), "useNativeEncoding","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.messagebody", "UNSPECIFIED"), "messageBody","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.targetclient", None), "targetClient","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.receiveccsid", "1208"), "receiveCCSID","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.priority", None), "priority","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.persistence", None), "persistence","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.floatingpointencoding", None), "floatingPointEncoding","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.replytostyle", "DEFAULT"), "replyToStyle","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.readaheadclose", None), "readAheadClose","MQQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueue.name", None), "name","MQQueue");
  if len(atts) != 0:
    print "Modifying MQQueue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MQQueue configuration up to date.";

  Util.popPathElement('MQQueue');
