from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DescriptivePropertyGroup import DescriptivePropertyGroup

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "MiddlewareVersionDescriptor";

  containmentpath = "%(parentconpath)sMiddlewareVersionDescriptor:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MiddlewareVersionDescriptor')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMiddlewareVersionDescriptor");
  exportedObject.put("roleName", "WebSphereMiddlewareVersionDescriptor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareversiondescriptor.version", objid, "version","MiddlewareVersionDescriptor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];

  versionDescriptor = Util.getOptionalAttribute(objid, 'versionDescriptor', 'MiddlewareVersionDescriptor');
  typeFolders={};
  if len(versionDescriptor) != 0:
    returndict = Util.createTypeFolder(respath, "DescriptivePropertyGroup", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, DescriptivePropertyGroup._export(versionDescriptor, currespath, "VersionDescriptor"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MiddlewareVersionDescriptor');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareVersionDescriptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MiddlewareVersionDescriptor on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;

def create(parentid, jsonobject):
  Util.pushPathElement('MiddlewareVersionDescriptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareVersionDescriptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "version", roleProperties.optString("websphere.middlewareversiondescriptor.version", None));
  print "Creating MiddlewareVersionDescriptor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MiddlewareVersionDescriptor", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescriptivePropertyGroup":
        DescriptivePropertyGroup.create(objid, curjsonobject);
  Util.popPathElement('MiddlewareVersionDescriptor');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MiddlewareVersionDescriptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareVersionDescriptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareversiondescriptor.version", None), "version","MiddlewareVersionDescriptor");
  if len(atts) != 0:
    print "Modifying MiddlewareVersionDescriptor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MiddlewareVersionDescriptor configuration up to date.";

  versiondescriptor = Util.parseConfigIdListAttribute(objid, 'versionDescriptor',"MiddlewareVersionDescriptor");
  if len(versiondescriptor) > 0:
    Util.remove(versiondescriptor);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescriptivePropertyGroup":
        DescriptivePropertyGroup.create(objid, curjsonobject, "VersionDescriptor");

  Util.popPathElement('MiddlewareVersionDescriptor');
