from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('NameBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereNameBinding");
  exportedObject.put("roleName", "WebSphereNameBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.linkednamingcontextid", objid, "linkedNamingContextId","NameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.stringifiedior", objid, "stringifiedIOR","NameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.namebindingtype", objid, "nameBindingType","NameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.insurl", objid, "insURL","NameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.serializedbytesasstring", objid, "serializedBytesAsString","NameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.namecomponent", objid, "nameComponent","NameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.contextid", objid, "contextId","NameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.javaclassname", objid, "javaClassName","NameBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.namebinding.cosbindingtype", objid, "cosBindingType","NameBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('NameBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('NameBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("NameBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "linkedNamingContextId", roleProperties.optString("websphere.namebinding.linkednamingcontextid", None));
  Util.addIfNotNone(properties, "stringifiedIOR", roleProperties.optString("websphere.namebinding.stringifiedior", None));
  Util.addIfNotNone(properties, "nameBindingType", roleProperties.optString("websphere.namebinding.namebindingtype", None));
  Util.addIfNotNone(properties, "insURL", roleProperties.optString("websphere.namebinding.insurl", None));
  Util.addIfNotNone(properties, "serializedBytesAsString", roleProperties.optString("websphere.namebinding.serializedbytesasstring", None));
  Util.addIfNotNone(properties, "nameComponent", roleProperties.optString("websphere.namebinding.namecomponent", None));
  Util.addIfNotNone(properties, "contextId", roleProperties.optString("websphere.namebinding.contextid", None));
  Util.addIfNotNone(properties, "javaClassName", roleProperties.optString("websphere.namebinding.javaclassname", None));
  Util.addIfNotNone(properties, "cosBindingType", roleProperties.optString("websphere.namebinding.cosbindingtype", None));
  print "Creating NameBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("NameBinding", parentid, properties);
  Util.popPathElement('NameBinding');

def update(objid,jsonobject):
  Util.pushPathElement('NameBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("NameBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.linkednamingcontextid", None), "linkedNamingContextId","NameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.stringifiedior", None), "stringifiedIOR","NameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.namebindingtype", None), "nameBindingType","NameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.insurl", None), "insURL","NameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.serializedbytesasstring", None), "serializedBytesAsString","NameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.namecomponent", None), "nameComponent","NameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.contextid", None), "contextId","NameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.javaclassname", None), "javaClassName","NameBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.namebinding.cosbindingtype", None), "cosBindingType","NameBinding");
  if len(atts) != 0:
    print "Modifying NameBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "NameBinding configuration up to date.";

  Util.popPathElement('NameBinding');
