from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBPSBBrokerTransactionality')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBPSBBrokerTransactionality");
  exportedObject.put("roleName", "WebSphereSIBPSBBrokerTransactionality");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbbrokertransactionality.messagetype", objid, "messageType","SIBPSBBrokerTransactionality");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbbrokertransactionality.batchsize", objid, "batchSize","SIBPSBBrokerTransactionality");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBPSBBrokerTransactionality');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBPSBBrokerTransactionality')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPSBBrokerTransactionality resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "messageType", roleProperties.optString("websphere.sibpsbbrokertransactionality.messagetype", None));
  Util.addIfNotNone(properties, "batchSize", roleProperties.optString("websphere.sibpsbbrokertransactionality.batchsize", None));
  print "Creating SIBPSBBrokerTransactionality with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBPSBBrokerTransactionality", parentid, properties);
  Util.popPathElement('SIBPSBBrokerTransactionality');

def update(objid,jsonobject):
  Util.pushPathElement('SIBPSBBrokerTransactionality')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPSBBrokerTransactionality resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbbrokertransactionality.messagetype", None), "messageType","SIBPSBBrokerTransactionality");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbbrokertransactionality.batchsize", None), "batchSize","SIBPSBBrokerTransactionality");
  if len(atts) != 0:
    print "Modifying SIBPSBBrokerTransactionality with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBPSBBrokerTransactionality configuration up to date.";

  Util.popPathElement('SIBPSBBrokerTransactionality');
