from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIPProxySettings')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIPProxySettings");
  exportedObject.put("roleName", "WebSphereSIPProxySettings");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.overloadresponsecode", objid, "overloadResponseCode","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.sipadvisormethodname", objid, "SIPAdvisorMethodName","SIPProxySettings");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.sipproxysettings.sipadvisoripaddress", objid, "SIPAdvisorIPAddress","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.defaultclustername", objid, "defaultClusterName","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.numadvisorrequestsbeforefailure", objid, "numAdvisorRequestsBeforeFailure","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.keepaliveinterval", objid, "keepAliveInterval","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.maxthroughputfactor", objid, "maxThroughputFactor","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.retryaftervalue", objid, "retryAfterValue","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.enableaccesslog", objid, "enableAccessLog","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.keepalivefailures", objid, "keepAliveFailures","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.proxyaccesslog", objid, "proxyAccessLog","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.overloadresponsereasonphrase", objid, "overloadResponseReasonPhrase","SIPProxySettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxysettings.accesslogmaximumsize", objid, "accessLogMaximumSize","SIPProxySettings");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SIPProxySettings");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIPProxySettings');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIPProxySettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPProxySettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "overloadResponseCode", roleProperties.optString("websphere.sipproxysettings.overloadresponsecode", None));
  Util.addIfNotNone(properties, "SIPAdvisorMethodName", roleProperties.optString("websphere.sipproxysettings.sipadvisormethodname", None));
  Util.addPathProperty(properties, "SIPAdvisorIPAddress", roleProperties.optString("websphere.sipproxysettings.sipadvisoripaddress", None));
  Util.addIfNotNone(properties, "defaultClusterName", roleProperties.optString("websphere.sipproxysettings.defaultclustername", None));
  Util.addIfNotNone(properties, "numAdvisorRequestsBeforeFailure", roleProperties.optString("websphere.sipproxysettings.numadvisorrequestsbeforefailure", None));
  Util.addIfNotNone(properties, "keepAliveInterval", roleProperties.optString("websphere.sipproxysettings.keepaliveinterval", None));
  Util.addIfNotNone(properties, "maxThroughputFactor", roleProperties.optString("websphere.sipproxysettings.maxthroughputfactor", None));
  Util.addIfNotNone(properties, "retryAfterValue", roleProperties.optString("websphere.sipproxysettings.retryaftervalue", None));
  Util.addIfNotNone(properties, "enableAccessLog", roleProperties.optString("websphere.sipproxysettings.enableaccesslog", None));
  Util.addIfNotNone(properties, "keepAliveFailures", roleProperties.optString("websphere.sipproxysettings.keepalivefailures", None));
  Util.addIfNotNone(properties, "proxyAccessLog", roleProperties.optString("websphere.sipproxysettings.proxyaccesslog", None));
  Util.addIfNotNone(properties, "overloadResponseReasonPhrase", roleProperties.optString("websphere.sipproxysettings.overloadresponsereasonphrase", None));
  Util.addIfNotNone(properties, "accessLogMaximumSize", roleProperties.optString("websphere.sipproxysettings.accesslogmaximumsize", None));
  print "Creating SIPProxySettings with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIPProxySettings", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPProxySettings');

def update(objid,jsonobject):
  Util.pushPathElement('SIPProxySettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPProxySettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.overloadresponsecode", None), "overloadResponseCode","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.sipadvisormethodname", None), "SIPAdvisorMethodName","SIPProxySettings");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.sipadvisoripaddress", None), "SIPAdvisorIPAddress","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.defaultclustername", None), "defaultClusterName","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.numadvisorrequestsbeforefailure", None), "numAdvisorRequestsBeforeFailure","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.keepaliveinterval", None), "keepAliveInterval","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.maxthroughputfactor", None), "maxThroughputFactor","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.retryaftervalue", None), "retryAfterValue","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.enableaccesslog", None), "enableAccessLog","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.keepalivefailures", None), "keepAliveFailures","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.proxyaccesslog", None), "proxyAccessLog","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.overloadresponsereasonphrase", None), "overloadResponseReasonPhrase","SIPProxySettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxysettings.accesslogmaximumsize", None), "accessLogMaximumSize","SIPProxySettings");
  if len(atts) != 0:
    print "Modifying SIPProxySettings with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIPProxySettings configuration up to date.";

  Property.removeProperties(objid, 'properties',"SIPProxySettings");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPProxySettings');
