from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('UnmanagedMiddlewareAppEdition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereUnmanagedMiddlewareAppEdition");
  exportedObject.put("roleName", "WebSphereUnmanagedMiddlewareAppEdition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.unmanagedmiddlewareappedition.name", objid, "name","UnmanagedMiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.unmanagedmiddlewareappedition.alias", objid, "alias","UnmanagedMiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.unmanagedmiddlewareappedition.description", objid, "description","UnmanagedMiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.unmanagedmiddlewareappedition.state", objid, "state","UnmanagedMiddlewareAppEdition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"UnmanagedMiddlewareAppEdition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('UnmanagedMiddlewareAppEdition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('UnmanagedMiddlewareAppEdition')
  if not jsonobject.has("roleProperties"):
    raise Exception("UnmanagedMiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.unmanagedmiddlewareappedition.name", None));
  Util.addIfNotNone(properties, "alias", roleProperties.optString("websphere.unmanagedmiddlewareappedition.alias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.unmanagedmiddlewareappedition.description", None));
  Util.addIfNotNone(properties, "state", roleProperties.optString("websphere.unmanagedmiddlewareappedition.state", None));
  print "Creating UnmanagedMiddlewareAppEdition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("UnmanagedMiddlewareAppEdition", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('UnmanagedMiddlewareAppEdition');

def update(objid,jsonobject):
  Util.pushPathElement('UnmanagedMiddlewareAppEdition')
  if not jsonobject.has("roleProperties"):
    raise Exception("UnmanagedMiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.unmanagedmiddlewareappedition.name", None), "name","UnmanagedMiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.unmanagedmiddlewareappedition.alias", None), "alias","UnmanagedMiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.unmanagedmiddlewareappedition.description", None), "description","UnmanagedMiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.unmanagedmiddlewareappedition.state", None), "state","UnmanagedMiddlewareAppEdition");
  if len(atts) != 0:
    print "Modifying UnmanagedMiddlewareAppEdition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "UnmanagedMiddlewareAppEdition configuration up to date.";

  Property.removeProperties(objid, 'properties',"UnmanagedMiddlewareAppEdition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('UnmanagedMiddlewareAppEdition');
