from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.Nonce')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscommonext.Nonce");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscommonext.Nonce");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.nonce.keyword", objid, "keyword","com.ibm.etools.webservice.wscommonext.Nonce");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.nonce.dialect", objid, "Dialect","com.ibm.etools.webservice.wscommonext.Nonce");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonext.nonce.name", objid, "name","com.ibm.etools.webservice.wscommonext.Nonce");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscommonext.Nonce');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.Nonce')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonext.Nonce resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "keyword", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.nonce.keyword", None));
  Util.addIfNotNone(properties, "Dialect", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.nonce.dialect", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.nonce.name", None));
  print "Creating com.ibm.etools.webservice.wscommonext.Nonce with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscommonext.Nonce", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscommonext.Nonce');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonext.Nonce')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonext.Nonce resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.nonce.keyword", None), "keyword","com.ibm.etools.webservice.wscommonext.Nonce");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.nonce.dialect", None), "Dialect","com.ibm.etools.webservice.wscommonext.Nonce");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonext.nonce.name", None), "name","com.ibm.etools.webservice.wscommonext.Nonce");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscommonext.Nonce with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscommonext.Nonce configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscommonext.Nonce');
