from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DPManager')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDPManager");
  exportedObject.put("roleName", "WebSphereDPManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpmanager.versionsdirectory", objid, "VersionsDirectory","DPManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpmanager.versionsstoredlimit", objid, "VersionsStoredLimit","DPManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DPManager");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DPManager');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DPManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "VersionsDirectory", roleProperties.optString("websphere.dpmanager.versionsdirectory", None));
  Util.addIfNotNone(properties, "VersionsStoredLimit", roleProperties.optString("websphere.dpmanager.versionsstoredlimit", None));
  print "Creating DPManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DPManager", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPManager');

def update(objid,jsonobject):
  Util.pushPathElement('DPManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpmanager.versionsdirectory", None), "VersionsDirectory","DPManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpmanager.versionsstoredlimit", None), "VersionsStoredLimit","DPManager");
  if len(atts) != 0:
    print "Modifying DPManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DPManager configuration up to date.";

  Property.removeProperties(objid, 'properties',"DPManager");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPManager');
