from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.descriptiveproperty.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'DescriptiveProperty');

  containmentpath = "%(parentconpath)sDescriptiveProperty:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('DescriptiveProperty')

  name = Util.getRequiredAttribute(objid, "name", 'DescriptiveProperty');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDescriptiveProperty");
  exportedObject.put("roleName", "WebSphereDescriptiveProperty");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.name", objid, "name","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.hoverhelpkey", objid, "hoverHelpKey","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.range", objid, "range","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.validationexpression", objid, "validationExpression","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.nlsrangekey", objid, "nlsRangeKey","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.required", objid, "required","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.type", objid, "type","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.inclusive", objid, "inclusive","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.value", objid, "value","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.firstclass", objid, "firstClass","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.displaynamekey", objid, "displayNameKey","DescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptiveproperty.description", objid, "description","DescriptiveProperty");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DescriptiveProperty');
  return result;


'''
  The Property objects should only be created by Property.createObjIfRole(...) in parent object.
  Remove doImport(..) so importobject.py will not create the Propety object the second time via containmentpath.
'''
def _doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("DescriptiveProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.descriptiveproperty.name"):
    raise Exception("Resource role properties does not contain websphere.descriptiveproperty.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create DescriptiveProperty on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('DescriptiveProperty')
  if not jsonobject.has("roleProperties"):
    raise Exception("DescriptiveProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.descriptiveproperty.name"):
    raise Exception("Resource role properties does not contain websphere.descriptiveproperty.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.descriptiveproperty.name", None));
  Util.addIfNotNone(properties, "hoverHelpKey", roleProperties.optString("websphere.descriptiveproperty.hoverhelpkey", None));
  Util.addIfNotNone(properties, "range", roleProperties.optString("websphere.descriptiveproperty.range", None));
  Util.addIfNotNone(properties, "validationExpression", roleProperties.optString("websphere.descriptiveproperty.validationexpression", None));
  Util.addIfNotNone(properties, "nlsRangeKey", roleProperties.optString("websphere.descriptiveproperty.nlsrangekey", None));
  Util.addIfNotNone(properties, "required", roleProperties.optString("websphere.descriptiveproperty.required", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.descriptiveproperty.type", None));
  Util.addIfNotNone(properties, "inclusive", roleProperties.optString("websphere.descriptiveproperty.inclusive", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.descriptiveproperty.value", None));
  Util.addIfNotNone(properties, "firstClass", roleProperties.optString("websphere.descriptiveproperty.firstclass", None));
  Util.addIfNotNone(properties, "displayNameKey", roleProperties.optString("websphere.descriptiveproperty.displaynamekey", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.descriptiveproperty.description", None));
  print "Creating DescriptiveProperty with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DescriptiveProperty", parentid, properties, attName);
  Util.popPathElement('DescriptiveProperty');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('DescriptiveProperty')
  if not jsonobject.has("roleProperties"):
    raise Exception("DescriptiveProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.descriptiveproperty.name"):
    raise Exception("Resource role properties does not contain websphere.descriptiveproperty.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.name", None), "name","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.hoverhelpkey", None), "hoverHelpKey","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.range", None), "range","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.validationexpression", None), "validationExpression","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.nlsrangekey", None), "nlsRangeKey","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.required", None), "required","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.type", None), "type","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.inclusive", None), "inclusive","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.value", None), "value","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.firstclass", None), "firstClass","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.displaynamekey", None), "displayNameKey","DescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptiveproperty.description", None), "description","DescriptiveProperty");
  if len(atts) != 0:
    print "Modifying DescriptiveProperty with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DescriptiveProperty configuration up to date.";

  Util.popPathElement('DescriptiveProperty');
