from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSNInstanceDocument')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSNInstanceDocument");
  exportedObject.put("roleName", "WebSphereWSNInstanceDocument");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsninstancedocument.filename", objid, "filename","WSNInstanceDocument");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsninstancedocument.sdorepositorykey", objid, "sdoRepositoryKey","WSNInstanceDocument");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsninstancedocument.description", objid, "description","WSNInstanceDocument");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsninstancedocument.doc", objid, "doc","WSNInstanceDocument");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"WSNInstanceDocument");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSNInstanceDocument');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSNInstanceDocument')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNInstanceDocument resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "filename", roleProperties.optString("websphere.wsninstancedocument.filename", None));
  Util.addIfNotNone(properties, "sdoRepositoryKey", roleProperties.optString("websphere.wsninstancedocument.sdorepositorykey", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wsninstancedocument.description", None));
  Util.addIfNotNone(properties, "doc", roleProperties.optString("websphere.wsninstancedocument.doc", None));
  print "Creating WSNInstanceDocument with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSNInstanceDocument", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNInstanceDocument');

def update(objid,jsonobject):
  Util.pushPathElement('WSNInstanceDocument')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNInstanceDocument resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsninstancedocument.filename", None), "filename","WSNInstanceDocument");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsninstancedocument.sdorepositorykey", None), "sdoRepositoryKey","WSNInstanceDocument");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsninstancedocument.description", None), "description","WSNInstanceDocument");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsninstancedocument.doc", None), "doc","WSNInstanceDocument");
  if len(atts) != 0:
    print "Modifying WSNInstanceDocument with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSNInstanceDocument configuration up to date.";

  Property.removeProperties(objid, 'property',"WSNInstanceDocument");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNInstanceDocument');
