from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from Property import Property
from Component import Component
from utilities import Util
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WorkloadManagementServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkloadManagementServer");
  exportedObject.put("roleName", "WebSphereWorkloadManagementServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workloadmanagementserver.name", objid, "name","WorkloadManagementServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WorkloadManagementServer");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "WorkloadManagementServer");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "WorkloadManagementServer");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"WorkloadManagementServer");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkloadManagementServer');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('WorkloadManagementServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkloadManagementServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.workloadmanagementserver.name", None));
  print "Creating WorkloadManagementServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkloadManagementServer", parentid, properties);

  Property.removeProperties(objid, 'properties',"WorkloadManagementServer");
  Component.removeComponents(objid, 'components', "WorkloadManagementServer");
  Service.removeServices(objid, 'services', "WorkloadManagementServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"WorkloadManagementServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);      
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('WorkloadManagementServer');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('WorkloadManagementServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkloadManagementServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workloadmanagementserver.name", None), "name","WorkloadManagementServer");
  if len(atts) != 0:
    print "Modifying WorkloadManagementServer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkloadManagementServer configuration up to date.";

  Property.removeProperties(objid, 'properties',"WorkloadManagementServer");
  Component.removeComponents(objid, 'components', "WorkloadManagementServer");
  Service.removeServices(objid, 'services', "WorkloadManagementServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"WorkloadManagementServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);    
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);                
  Util.popPathElement('WorkloadManagementServer');
