from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationServerClusterMember')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationServerClusterMember");
  exportedObject.put("roleName", "WebSphereApplicationServerClusterMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverclustermember.servername", objid, "serverName","ApplicationServerClusterMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverclustermember.nodename", objid, "nodeName","ApplicationServerClusterMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationServerClusterMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ApplicationServerClusterMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerClusterMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.applicationserverclustermember.servername", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.applicationserverclustermember.nodename", None));
  print "Creating ApplicationServerClusterMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationServerClusterMember", parentid, properties);
  Util.popPathElement('ApplicationServerClusterMember');

def update(objid,jsonobject):
  Util.pushPathElement('ApplicationServerClusterMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerClusterMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverclustermember.servername", None), "serverName","ApplicationServerClusterMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverclustermember.nodename", None), "nodeName","ApplicationServerClusterMember");
  if len(atts) != 0:
    print "Modifying ApplicationServerClusterMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationServerClusterMember configuration up to date.";

  Util.popPathElement('ApplicationServerClusterMember');
