from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EJBDeployment')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEJBDeployment");
  exportedObject.put("roleName", "WebSphereEJBDeployment");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbdeployment.ejbname", objid, "ejbName","EJBDeployment");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EJBDeployment');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EJBDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "ejbName", roleProperties.optString("websphere.ejbdeployment.ejbname", None));
  print "Creating EJBDeployment with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EJBDeployment", parentid, properties);
  Util.popPathElement('EJBDeployment');

def update(objid,jsonobject):
  Util.pushPathElement('EJBDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbdeployment.ejbname", None), "ejbName","EJBDeployment");
  if len(atts) != 0:
    print "Modifying EJBDeployment with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EJBDeployment configuration up to date.";

  Util.popPathElement('EJBDeployment');
