from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.eventbustransmissionprofile.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'EventBusTransmissionProfile');

  containmentpath = "%(parentconpath)sEventBusTransmissionProfile:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('EventBusTransmissionProfile')

  name = Util.getRequiredAttribute(objid, "name", 'EventBusTransmissionProfile');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEventBusTransmissionProfile");
  exportedObject.put("roleName", "WebSphereEventBusTransmissionProfile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventbustransmissionprofile.name", objid, "name","EventBusTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventbustransmissionprofile.category", objid, "category","EventBusTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventbustransmissionprofile.providertype", objid, "providerType","EventBusTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventbustransmissionprofile.jndiname", objid, "jndiName","EventBusTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventbustransmissionprofile.eventbusjndiname", objid, "eventBusJNDIName","EventBusTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventbustransmissionprofile.description", objid, "description","EventBusTransmissionProfile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EventBusTransmissionProfile');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not Util.isValidType("EventBusTransmissionProfile", 1):
    return None;
  if not jsonobject.has("roleProperties"):
    raise Exception("EventBusTransmissionProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.eventbustransmissionprofile.name"):
    raise Exception("Resource role properties does not contain websphere.eventbustransmissionprofile.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create EventBusTransmissionProfile on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  if not Util.isValidType("EventBusTransmissionProfile", 1):
    return None;
  Util.pushPathElement('EventBusTransmissionProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventBusTransmissionProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.eventbustransmissionprofile.name"):
    raise Exception("Resource role properties does not contain websphere.eventbustransmissionprofile.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.eventbustransmissionprofile.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.eventbustransmissionprofile.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.eventbustransmissionprofile.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.eventbustransmissionprofile.jndiname", None));
  Util.addIfNotNone(properties, "eventBusJNDIName", roleProperties.optString("websphere.eventbustransmissionprofile.eventbusjndiname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.eventbustransmissionprofile.description", None));
  print "Creating EventBusTransmissionProfile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EventBusTransmissionProfile", parentid, properties);
  Util.popPathElement('EventBusTransmissionProfile');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('EventBusTransmissionProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventBusTransmissionProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.eventbustransmissionprofile.name"):
    raise Exception("Resource role properties does not contain websphere.eventbustransmissionprofile.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventbustransmissionprofile.name", None), "name","EventBusTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventbustransmissionprofile.category", None), "category","EventBusTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventbustransmissionprofile.providertype", None), "providerType","EventBusTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventbustransmissionprofile.jndiname", None), "jndiName","EventBusTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventbustransmissionprofile.eventbusjndiname", None), "eventBusJNDIName","EventBusTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventbustransmissionprofile.description", None), "description","EventBusTransmissionProfile");
  if len(atts) != 0:
    print "Modifying EventBusTransmissionProfile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EventBusTransmissionProfile configuration up to date.";

  Util.popPathElement('EventBusTransmissionProfile');
