from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.eventserverprofile.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'EventServerProfile');

  containmentpath = "%(parentconpath)sEventServerProfile:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('EventServerProfile')

  name = Util.getRequiredAttribute(objid, "name", 'EventServerProfile');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEventServerProfile");
  exportedObject.put("roleName", "WebSphereEventServerProfile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.datastorejndiname", objid, "dataStoreJNDIName","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.name", objid, "name","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.category", objid, "category","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.providertype", objid, "providerType","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.jndiname", objid, "jndiName","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.enabledatastore", objid, "enableDataStore","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.enableeventdistribution", objid, "enableEventDistribution","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.datastoreprofilejndiname", objid, "dataStoreProfileJNDIName","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.description", objid, "description","EventServerProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventserverprofile.eventgroupprofilelistjndiname", objid, "eventGroupProfileListJNDIName","EventServerProfile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EventServerProfile');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not Util.isValidType("EventServerProfile", 1):
    return None;
  if not jsonobject.has("roleProperties"):
    raise Exception("EventServerProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.eventserverprofile.name"):
    raise Exception("Resource role properties does not contain websphere.eventserverprofile.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create EventServerProfile on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  if not Util.isValidType("EventServerProfile", 1):
    return None;
  Util.pushPathElement('EventServerProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventServerProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.eventserverprofile.name"):
    raise Exception("Resource role properties does not contain websphere.eventserverprofile.name!");

  properties = [];
  Util.addIfNotNone(properties, "dataStoreJNDIName", roleProperties.optString("websphere.eventserverprofile.datastorejndiname", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.eventserverprofile.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.eventserverprofile.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.eventserverprofile.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.eventserverprofile.jndiname", None));
  Util.addIfNotNone(properties, "enableDataStore", roleProperties.optString("websphere.eventserverprofile.enabledatastore", None));
  Util.addIfNotNone(properties, "enableEventDistribution", roleProperties.optString("websphere.eventserverprofile.enableeventdistribution", None));
  Util.addIfNotNone(properties, "dataStoreProfileJNDIName", roleProperties.optString("websphere.eventserverprofile.datastoreprofilejndiname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.eventserverprofile.description", None));
  Util.addIfNotNone(properties, "eventGroupProfileListJNDIName", roleProperties.optString("websphere.eventserverprofile.eventgroupprofilelistjndiname", None));
  print "Creating EventServerProfile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EventServerProfile", parentid, properties);
  Util.popPathElement('EventServerProfile');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('EventServerProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventServerProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.eventserverprofile.name"):
    raise Exception("Resource role properties does not contain websphere.eventserverprofile.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.datastorejndiname", None), "dataStoreJNDIName","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.name", None), "name","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.category", None), "category","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.providertype", None), "providerType","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.jndiname", None), "jndiName","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.enabledatastore", None), "enableDataStore","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.enableeventdistribution", None), "enableEventDistribution","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.datastoreprofilejndiname", None), "dataStoreProfileJNDIName","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.description", None), "description","EventServerProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventserverprofile.eventgroupprofilelistjndiname", None), "eventGroupProfileListJNDIName","EventServerProfile");
  if len(atts) != 0:
    print "Modifying EventServerProfile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EventServerProfile configuration up to date.";

  Util.popPathElement('EventServerProfile');
