from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSSecurityInboundConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSSecurityInboundConfig");
  exportedObject.put("roleName", "WebSphereSIBWSSecurityInboundConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwssecurityinboundconfig.name", objid, "name","SIBWSSecurityInboundConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSSecurityInboundConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSSecurityInboundConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityInboundConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwssecurityinboundconfig.name", None));
  print "Creating SIBWSSecurityInboundConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSSecurityInboundConfig", parentid, properties);
  Util.popPathElement('SIBWSSecurityInboundConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSSecurityInboundConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityInboundConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwssecurityinboundconfig.name", None), "name","SIBWSSecurityInboundConfig");
  if len(atts) != 0:
    print "Modifying SIBWSSecurityInboundConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSSecurityInboundConfig configuration up to date.";

  Util.popPathElement('SIBWSSecurityInboundConfig');
