from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASEjbRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASEjbRef");
  exportedObject.put("roleName", "WebSphereWASEjbRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbref.ejbrefkind", objid, "ejbRefKind","WASEjbRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbref.lookupname", objid, "lookupName","WASEjbRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbref.remote", objid, "remote","WASEjbRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbref.refname", objid, "refName","WASEjbRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbref.type", objid, "type","WASEjbRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbref.home", objid, "home","WASEjbRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbref.link", objid, "link","WASEjbRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbref.mappedname", objid, "mappedName","WASEjbRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASEjbRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASEjbRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASEjbRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "ejbRefKind", roleProperties.optString("websphere.wasejbref.ejbrefkind", None));
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.wasejbref.lookupname", None));
  Util.addIfNotNone(properties, "remote", roleProperties.optString("websphere.wasejbref.remote", None));
  Util.addIfNotNone(properties, "refName", roleProperties.optString("websphere.wasejbref.refname", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.wasejbref.type", None));
  Util.addIfNotNone(properties, "home", roleProperties.optString("websphere.wasejbref.home", None));
  Util.addIfNotNone(properties, "link", roleProperties.optString("websphere.wasejbref.link", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.wasejbref.mappedname", None));
  print "Creating WASEjbRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASEjbRef", parentid, properties);
  Util.popPathElement('WASEjbRef');

def update(objid,jsonobject):
  Util.pushPathElement('WASEjbRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASEjbRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbref.ejbrefkind", None), "ejbRefKind","WASEjbRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbref.lookupname", None), "lookupName","WASEjbRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbref.remote", None), "remote","WASEjbRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbref.refname", None), "refName","WASEjbRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbref.type", None), "type","WASEjbRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbref.home", None), "home","WASEjbRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbref.link", None), "link","WASEjbRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbref.mappedname", None), "mappedName","WASEjbRef");
  if len(atts) != 0:
    print "Modifying WASEjbRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASEjbRef configuration up to date.";

  Util.popPathElement('WASEjbRef');
