from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ClusteredTarget')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereClusteredTarget");
  exportedObject.put("roleName", "WebSphereClusteredTarget");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteredtarget.name", objid, "name","ClusteredTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ClusteredTarget');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ClusteredTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClusteredTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.clusteredtarget.name", None));
  print "Creating ClusteredTarget with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ClusteredTarget", parentid, properties);
  Util.popPathElement('ClusteredTarget');

def update(objid,jsonobject):
  Util.pushPathElement('ClusteredTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClusteredTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteredtarget.name", None), "name","ClusteredTarget");
  if len(atts) != 0:
    print "Modifying ClusteredTarget with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ClusteredTarget configuration up to date.";

  Util.popPathElement('ClusteredTarget');
