from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DeploymentTargetMapping import DeploymentTargetMapping
from Classloader import Classloader

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DeployedObject')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDeployedObject");
  exportedObject.put("roleName", "WebSphereDeployedObject");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deployedobject.startingweight", objid, "startingWeight","DeployedObject");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deployedobject.deploymentid", objid, "deploymentId","DeployedObject");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"DeployedObject");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      returndict = Util.createTypeFolder(respath, "DeploymentTargetMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DeploymentTargetMapping._export(targetmapping, currespath, "DeploymentTargetMapping%s" % i));
      i = i + 1;
      
  classloader = Util.getRequiredAttribute(objid, 'classloader',"DeployedObject");
  if classloader is not None and len(classloader) > 0:
    returndict = Util.createTypeFolder(respath, "Classloader", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, Classloader._export(classloader, currespath, "Classloader"));      
      
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DeployedObject');
  return result;

def create(parentid, jsonobject):
  Util.pushPathElement('DeployedObject')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "startingWeight", roleProperties.optString("websphere.deployedobject.startingweight", None));
  Util.addIfNotNone(properties, "deploymentId", roleProperties.optString("websphere.deployedobject.deploymentid", None));
  print "Creating DeployedObject with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DeployedObject", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);    
  Util.popPathElement('DeployedObject');

def update(objid,jsonobject):
  Util.pushPathElement('DeployedObject')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deployedobject.startingweight", None), "startingWeight","DeployedObject");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deployedobject.deploymentid", None), "deploymentId","DeployedObject");
  if len(atts) != 0:
    print "Modifying DeployedObject with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DeployedObject configuration up to date.";

  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"DeployedObject");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      Util.remove(targetmapping);
      
  classloader = Util.getRequiredAttribute(objid, 'classloader',"DeployedObject");
  if classloader is not None and len(classloader) > 0:
    Util.remove(classloader);  

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);    
  Util.popPathElement('DeployedObject');
