from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from CoreGroupAccessPointRef import CoreGroupAccessPointRef;
from TunnelPeerAccessPointRef import TunnelPeerAccessPointRef
from utilities import Util
from Property import Property

__name_att__ = 'websphere.tunnelaccesspointgroup.name';

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'TunnelAccessPointGroup');

  containmentpath = "%(parentconpath)sTunnelAccessPointGroup:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TunnelAccessPointGroup')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTunnelAccessPointGroup");
  exportedObject.put("roleName", "WebSphereTunnelAccessPointGroup");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tunnelaccesspointgroup.membercommunicationkey", objid, "memberCommunicationKey","TunnelAccessPointGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tunnelaccesspointgroup.name", objid, "name","TunnelAccessPointGroup");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"TunnelAccessPointGroup");
  cgaprefs = Util.parseConfigIdListAttribute(objid, 'coreGroupAccessPointRefs', 'TunnelAccessPointGroup');
  for cgapref in cgaprefs:
    if cgapref is not None and len(cgapref) > 0:
      returndict = Util.createTypeFolder(respath, "CoreGroupAccessPointRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, CoreGroupAccessPointRef._export(cgapref, currespath));

  tpaprefs = Util.parseConfigIdListAttribute(objid, 'tunnelPeerAccessPointRefs', 'TunnelAccessPointGroup');
  for tpapref in tpaprefs:
    if tpapref is not None and len(tpapref) > 0:
      returndict = Util.createTypeFolder(respath, "TunnelPeerAccessPointRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, TunnelPeerAccessPointRef._export(tpapref, currespath));
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TunnelAccessPointGroup');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("TunnelAccessPointGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.tunnelaccesspointgroup.name"):
    raise Exception("Resource role properties does not contain websphere.tunnelaccesspointgroup.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create TunnelAccessPointGroup on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;


def create(parentid, jsonobject):
  Util.pushPathElement('TunnelAccessPointGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("TunnelAccessPointGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "memberCommunicationKey", roleProperties.optString("websphere.tunnelaccesspointgroup.membercommunicationkey", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.tunnelaccesspointgroup.name", None));
  print "Creating TunnelAccessPointGroup with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TunnelAccessPointGroup", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TunnelAccessPointGroup');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('TunnelAccessPointGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("TunnelAccessPointGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tunnelaccesspointgroup.membercommunicationkey", None), "memberCommunicationKey","TunnelAccessPointGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tunnelaccesspointgroup.name", None), "name","TunnelAccessPointGroup");

  atts.append(['coreGroupAccessPointRefs','']);
  atts.append(['tunnelPeerAccessPointRefs','']);
  if len(atts) != 0:
    print "Modifying TunnelAccessPointGroup with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TunnelAccessPointGroup configuration up to date.";

  Property.removeProperties(objid, 'properties',"TunnelAccessPointGroup");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TunnelAccessPointGroup');
