from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('SSLConfigRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSSLConfigRef");
  exportedObject.put("roleName", "WebSphereSSLConfigRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sslconfigref.aliasname", objid, "alias","SSLConfig");
  
  scopeName = None;
  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'SSLConfig');
  if managementScope is not None and len(managementScope) > 0:
    scopeName = Util.getOptionalAttribute(managementScope, 'scopeName', 'ManagementScope');
    if scopeName is not None and len(scopeName) > 0:
      Util.addToJsonIfNotNone(roleProperties, "websphere.sslconfigref.scopename", scopeName);
  
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SSLConfigRef');
  return result;

def create(parentid, jsonobject, parentAtt, force = 0):
  Util.pushPathElement('SSLConfigRef')
  
  if not jsonobject.has("roleProperties"):
    raise Exception("SSLConfigRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.sslconfigref.aliasname'):
    raise Exception("SSLConfigRef resource has no property named websphere.sslconfigref.aliasname!");
  if not roleProperties.has('websphere.sslconfigref.scopename'):
    raise Exception("SSLConfigRef resource has no property named websphere.sslconfigref.scopename!");

  sslConfigAliasName = roleProperties.getString('websphere.sslconfigref.aliasname');
  sslConfigScopeName = roleProperties.getString('websphere.sslconfigref.scopename');

  sslConfigId = None;
  sslConfigs = Util.getid("/SSLConfig:/").splitlines();
  if len(sslConfigs) > 0:
    for sslConfig in sslConfigs:
      if len(sslConfig) > 0:
        alias = Util.getRequiredAttribute(sslConfig, "alias", "SSLConfig" );
        scopeName = None;
        managementScope = Util.getOptionalAttribute(sslConfig, 'managementScope', 'SSLConfig');
        if managementScope is not None and len(managementScope) > 0:
          scopeName = Util.getOptionalAttribute(managementScope, 'scopeName', 'ManagementScope');
        
        if (sslConfigAliasName == alias and sslConfigScopeName == scopeName):
          sslConfigId = sslConfig;
          break;
  
  if sslConfigId is None or len(sslConfigId) < 1:
    raise Exception("Could not find sslconfig named %(name)s with management scopename of %(scopeName)s" % { 'name':sslConfigAliasName, 'scopeName':sslConfigScopeName } );

  properties = [];
  properties.append([parentAtt, sslConfigId]);
  Log.debug(properties);
  Log.debug(parentid);
  print "Creating SSLConfigRef to %(id)s for attribute %(att)s" % { 'id':sslConfigId, 'att':parentAtt };
  objid = Util.modify(parentid, properties, force);
  Log.debug("Finished Creating SSLConfigRef to %(id)s for attribute %(att)s" % { 'id':sslConfigId, 'att':parentAtt });
  Util.popPathElement('SSLConfigRef');
