from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.schedulerprovider.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'SchedulerProvider');

  containmentpath = "%(parentconpath)sSchedulerProvider:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('SchedulerProvider')

  name = Util.getRequiredAttribute(objid, "name", 'SchedulerProvider');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSchedulerProvider");
  exportedObject.put("roleName", "WebSphereSchedulerProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.schedulerprovider.classpath", objid, "classpath","SchedulerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerprovider.name", objid, "name","SchedulerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerprovider.isolatedclassloader", objid, "isolatedClassLoader","SchedulerProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.schedulerprovider.nativepath", objid, "nativepath","SchedulerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerprovider.description", objid, "description","SchedulerProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.schedulerprovider.providertype", objid, "providerType","SchedulerProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SchedulerProvider');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("SchedulerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.schedulerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.schedulerprovider.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create SchedulerProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('SchedulerProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("SchedulerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.schedulerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.schedulerprovider.name!");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.schedulerprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.schedulerprovider.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.schedulerprovider.isolatedclassloader", None));
  Util.addPathProperty(properties, "nativepath", roleProperties.optString("websphere.schedulerprovider.nativepath", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.schedulerprovider.description", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.schedulerprovider.providertype", None));
  print "Creating SchedulerProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SchedulerProvider", parentid, properties);
  Util.popPathElement('SchedulerProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('SchedulerProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("SchedulerProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.schedulerprovider.name"):
    raise Exception("Resource role properties does not contain websphere.schedulerprovider.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerprovider.classpath", None), "classpath","SchedulerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerprovider.name", None), "name","SchedulerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerprovider.isolatedclassloader", None), "isolatedClassLoader","SchedulerProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerprovider.nativepath", None), "nativepath","SchedulerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerprovider.description", None), "description","SchedulerProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.schedulerprovider.providertype", None), "providerType","SchedulerProvider");
  if len(atts) != 0:
    print "Modifying SchedulerProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SchedulerProvider configuration up to date.";

  Util.popPathElement('SchedulerProvider');
