from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSNotification')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSNotification");
  exportedObject.put("roleName", "WebSphereWSNotification");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnotification.name", objid, "name","WSNotification");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnotification.emailformat", objid, "emailFormat","WSNotification");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnotification.sendemail", objid, "sendEmail","WSNotification");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnotification.logtosystemout", objid, "logToSystemOut","WSNotification");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnotification.emaillist", objid, "emailList","WSNotification");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnotification.sslconfig", objid, "sslConfig","WSNotification");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsnotification.sendsecure", objid, "sendSecure","WSNotification");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WSNotification");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSNotification');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSNotification')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNotification resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wsnotification.name", None));
  Util.addIfNotNone(properties, "emailFormat", roleProperties.optString("websphere.wsnotification.emailformat", None));
  Util.addIfNotNone(properties, "sendEmail", roleProperties.optString("websphere.wsnotification.sendemail", None));
  Util.addIfNotNone(properties, "logToSystemOut", roleProperties.optString("websphere.wsnotification.logtosystemout", None));
  Util.addIfNotNone(properties, "emailList", roleProperties.optString("websphere.wsnotification.emaillist", None));
  Util.addIfNotNone(properties, "sslConfig", roleProperties.optString("websphere.wsnotification.sslconfig", None));
  Util.addIfNotNone(properties, "sendSecure", roleProperties.optString("websphere.wsnotification.sendsecure", None));
  print "Creating WSNotification with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSNotification", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNotification');

def update(objid,jsonobject):
  Util.pushPathElement('WSNotification')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSNotification resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnotification.name", None), "name","WSNotification");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnotification.emailformat", None), "emailFormat","WSNotification");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnotification.sendemail", None), "sendEmail","WSNotification");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnotification.logtosystemout", None), "logToSystemOut","WSNotification");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnotification.emaillist", None), "emailList","WSNotification");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnotification.sslconfig", None), "sslConfig","WSNotification");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsnotification.sendsecure", None), "sendSecure","WSNotification");
  if len(atts) != 0:
    print "Modifying WSNotification with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSNotification configuration up to date.";

  Property.removeProperties(objid, 'properties',"WSNotification");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WSNotification');
