from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSSchedule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSSchedule");
  exportedObject.put("roleName", "WebSphereWSSchedule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsschedule.hour", objid, "hour","WSSchedule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsschedule.dayofweek", objid, "dayOfWeek","WSSchedule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsschedule.name", objid, "name","WSSchedule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsschedule.frequency", objid, "frequency","WSSchedule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsschedule.nextstartdate", objid, "nextStartDate","WSSchedule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsschedule.minute", objid, "minute","WSSchedule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSSchedule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSSchedule')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSSchedule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "hour", roleProperties.optString("websphere.wsschedule.hour", None));
  Util.addIfNotNone(properties, "dayOfWeek", roleProperties.optString("websphere.wsschedule.dayofweek", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wsschedule.name", None));
  Util.addIfNotNone(properties, "frequency", roleProperties.optString("websphere.wsschedule.frequency", None));
  Util.addIfNotNone(properties, "nextStartDate", roleProperties.optString("websphere.wsschedule.nextstartdate", None));
  Util.addIfNotNone(properties, "minute", roleProperties.optString("websphere.wsschedule.minute", None));
  print "Creating WSSchedule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSSchedule", parentid, properties);
  Util.popPathElement('WSSchedule');

def update(objid,jsonobject):
  Util.pushPathElement('WSSchedule')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSSchedule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsschedule.hour", None), "hour","WSSchedule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsschedule.dayofweek", None), "dayOfWeek","WSSchedule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsschedule.name", None), "name","WSSchedule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsschedule.frequency", None), "frequency","WSSchedule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsschedule.nextstartdate", None), "nextStartDate","WSSchedule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsschedule.minute", None), "minute","WSSchedule");
  if len(atts) != 0:
    print "Modifying WSSchedule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSSchedule configuration up to date.";

  Util.popPathElement('WSSchedule');
