from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "MonitoredDirectoryDeployment";

  containmentpath = "%(parentconpath)sMonitoredDirectoryDeployment:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MonitoredDirectoryDeployment')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMonitoredDirectoryDeployment");
  exportedObject.put("roleName", "WebSphereMonitoredDirectoryDeployment");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.monitoreddirectorydeployment.enabled", objid, "enabled","MonitoredDirectoryDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.monitoreddirectorydeployment.monitoreddirectory", objid, "monitoredDirectory","MonitoredDirectoryDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.monitoreddirectorydeployment.pollinginterval", objid, "pollingInterval","MonitoredDirectoryDeployment");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MonitoredDirectoryDeployment');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MonitoredDirectoryDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  
  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MonitoredDirectoryDeployment on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;


def create(parentid, jsonobject):
  Util.pushPathElement('MonitoredDirectoryDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("MonitoredDirectoryDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.monitoreddirectorydeployment.enabled", None));
  Util.addIfNotNone(properties, "monitoredDirectory", roleProperties.optString("websphere.monitoreddirectorydeployment.monitoreddirectory", None));
  Util.addIfNotNone(properties, "pollingInterval", roleProperties.optString("websphere.monitoreddirectorydeployment.pollinginterval", None));
  print "Creating MonitoredDirectoryDeployment with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MonitoredDirectoryDeployment", parentid, properties);
  Util.popPathElement('MonitoredDirectoryDeployment');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MonitoredDirectoryDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("MonitoredDirectoryDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.monitoreddirectorydeployment.enabled", None), "enabled","MonitoredDirectoryDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.monitoreddirectorydeployment.monitoreddirectory", None), "monitoredDirectory","MonitoredDirectoryDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.monitoreddirectorydeployment.pollinginterval", None), "pollingInterval","MonitoredDirectoryDeployment");
  if len(atts) != 0:
    print "Modifying MonitoredDirectoryDeployment with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MonitoredDirectoryDeployment configuration up to date.";

  Util.popPathElement('MonitoredDirectoryDeployment');
