from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.authorizationprovider.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'AuthorizationProvider');

  containmentpath = "%(parentconpath)sAuthorizationProvider:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('AuthorizationProvider')

  name = Util.getRequiredAttribute(objid, "name", 'AuthorizationProvider');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuthorizationProvider");
  exportedObject.put("roleName", "WebSphereAuthorizationProvider");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.j2eepolicyimplclassname", objid, "j2eePolicyImplClassName","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.name", objid, "name","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.requiresejbargumentspolicycontexthandler", objid, "requiresEJBArgumentsPolicyContextHandler","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.policyconfigurationfactoryimplclassname", objid, "policyConfigurationFactoryImplClassName","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.roleconfigurationfactoryimplclassname", objid, "roleConfigurationFactoryImplClassName","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.roleassignmentconfigimplclassname", objid, "roleAssignmentConfigImplClassName","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.supportsdynamicmoduleupdates", objid, "supportsDynamicModuleUpdates","AuthorizationProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.authorizationprovider.supportedpermissions", objid, "supportedPermissions","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.required", objid, "required","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.policyconfigurationimplclassname", objid, "policyConfigurationImplClassName","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.description", objid, "description","AuthorizationProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationprovider.initializejaccproviderclassname", objid, "initializeJACCProviderClassName","AuthorizationProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AuthorizationProvider");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuthorizationProvider');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthorizationProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.authorizationprovider.name"):
    raise Exception("Resource role properties does not contain websphere.authorizationprovider.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create AuthorizationProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('AuthorizationProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthorizationProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.authorizationprovider.name"):
    raise Exception("Resource role properties does not contain websphere.authorizationprovider.name!");

  properties = [];
  Util.addIfNotNone(properties, "j2eePolicyImplClassName", roleProperties.optString("websphere.authorizationprovider.j2eepolicyimplclassname", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.authorizationprovider.name", None));
  Util.addIfNotNone(properties, "requiresEJBArgumentsPolicyContextHandler", roleProperties.optString("websphere.authorizationprovider.requiresejbargumentspolicycontexthandler", None));
  Util.addIfNotNone(properties, "policyConfigurationFactoryImplClassName", roleProperties.optString("websphere.authorizationprovider.policyconfigurationfactoryimplclassname", None));
  Util.addIfNotNone(properties, "roleConfigurationFactoryImplClassName", roleProperties.optString("websphere.authorizationprovider.roleconfigurationfactoryimplclassname", None));
  Util.addIfNotNone(properties, "roleAssignmentConfigImplClassName", roleProperties.optString("websphere.authorizationprovider.roleassignmentconfigimplclassname", None));
  Util.addIfNotNone(properties, "supportsDynamicModuleUpdates", roleProperties.optString("websphere.authorizationprovider.supportsdynamicmoduleupdates", None));
  Util.addPathProperty(properties, "supportedPermissions", roleProperties.optString("websphere.authorizationprovider.supportedpermissions", None));
  Util.addIfNotNone(properties, "required", roleProperties.optString("websphere.authorizationprovider.required", None));
  Util.addIfNotNone(properties, "policyConfigurationImplClassName", roleProperties.optString("websphere.authorizationprovider.policyconfigurationimplclassname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.authorizationprovider.description", None));
  Util.addIfNotNone(properties, "initializeJACCProviderClassName", roleProperties.optString("websphere.authorizationprovider.initializejaccproviderclassname", None));
  print "Creating AuthorizationProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuthorizationProvider", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AuthorizationProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('AuthorizationProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthorizationProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.authorizationprovider.name"):
    raise Exception("Resource role properties does not contain websphere.authorizationprovider.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.j2eepolicyimplclassname", None), "j2eePolicyImplClassName","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.name", None), "name","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.requiresejbargumentspolicycontexthandler", None), "requiresEJBArgumentsPolicyContextHandler","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.policyconfigurationfactoryimplclassname", None), "policyConfigurationFactoryImplClassName","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.roleconfigurationfactoryimplclassname", None), "roleConfigurationFactoryImplClassName","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.roleassignmentconfigimplclassname", None), "roleAssignmentConfigImplClassName","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.supportsdynamicmoduleupdates", None), "supportsDynamicModuleUpdates","AuthorizationProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.supportedpermissions", None), "supportedPermissions","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.required", None), "required","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.policyconfigurationimplclassname", None), "policyConfigurationImplClassName","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.description", None), "description","AuthorizationProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationprovider.initializejaccproviderclassname", None), "initializeJACCProviderClassName","AuthorizationProvider");
  if len(atts) != 0:
    print "Modifying AuthorizationProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuthorizationProvider configuration up to date.";

  Property.removeProperties(objid, 'properties',"AuthorizationProvider");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('AuthorizationProvider');
