from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.httptunnelinboundchannel.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'HTTPTunnelInboundChannel');

  containmentpath = "%(parentconpath)sHTTPTunnelInboundChannel:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('HTTPTunnelInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'HTTPTunnelInboundChannel');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHTTPTunnelInboundChannel");
  exportedObject.put("roleName", "WebSphereHTTPTunnelInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httptunnelinboundchannel.name", objid, "name","HTTPTunnelInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httptunnelinboundchannel.discriminationweight", objid, "discriminationWeight","HTTPTunnelInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"HTTPTunnelInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPTunnelInboundChannel');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPTunnelInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.httptunnelinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.httptunnelinboundchannel.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create HTTPTunnelInboundChannel on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('HTTPTunnelInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPTunnelInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.httptunnelinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.httptunnelinboundchannel.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.httptunnelinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.httptunnelinboundchannel.discriminationweight", None));
  print "Creating HTTPTunnelInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HTTPTunnelInboundChannel", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('HTTPTunnelInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('HTTPTunnelInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPTunnelInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.httptunnelinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.httptunnelinboundchannel.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httptunnelinboundchannel.name", None), "name","HTTPTunnelInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httptunnelinboundchannel.discriminationweight", None), "discriminationWeight","HTTPTunnelInboundChannel");
  if len(atts) != 0:
    print "Modifying HTTPTunnelInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HTTPTunnelInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"HTTPTunnelInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('HTTPTunnelInboundChannel');
