from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('QName')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereQName");
  exportedObject.put("roleName", "WebSphereQName");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.qname.localpart", objid, "localPart","QName");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.qname.combinedqname", objid, "combinedQName","QName");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.qname.namespaceuri", objid, "namespaceURI","QName");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.qname.internalprefixornsuri", objid, "internalPrefixOrNsURI","QName");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('QName');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('QName')
  if not jsonobject.has("roleProperties"):
    raise Exception("QName resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "localPart", roleProperties.optString("websphere.qname.localpart", None));
  Util.addIfNotNone(properties, "combinedQName", roleProperties.optString("websphere.qname.combinedqname", None));
  Util.addIfNotNone(properties, "namespaceURI", roleProperties.optString("websphere.qname.namespaceuri", None));
  Util.addIfNotNone(properties, "internalPrefixOrNsURI", roleProperties.optString("websphere.qname.internalprefixornsuri", None));
  print "Creating QName with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("QName", parentid, properties);
  Util.popPathElement('QName');

def update(objid,jsonobject):
  Util.pushPathElement('QName')
  if not jsonobject.has("roleProperties"):
    raise Exception("QName resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.qname.localpart", None), "localPart","QName");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.qname.combinedqname", None), "combinedQName","QName");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.qname.namespaceuri", None), "namespaceURI","QName");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.qname.internalprefixornsuri", None), "internalPrefixOrNsURI","QName");
  if len(atts) != 0:
    print "Modifying QName with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "QName configuration up to date.";

  Util.popPathElement('QName');
