from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util
from AuditServiceProvider import AuditServiceProvider

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('AuditServiceProviderRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuditServiceProviderRef");
  exportedObject.put("roleName", "WebSphereAuditServiceProviderRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditserviceproviderref.name", objid, "name","AuditServiceProvider");
  
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuditServiceProviderRef');
  return result;

def create(parentid, jsonobject, parentAtt):
  Util.pushPathElement('AuditServiceProviderRef')
  
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditServiceProviderRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.auditserviceproviderref.name'):
    raise Exception("AuditServiceProviderRef resource has no property named websphere.auditserviceproviderref.name!");

  name = roleProperties.getString('websphere.auditserviceproviderref.name')

  auditServiceProviderId = None;
  auditServiceProviders = Util.getid("/AuditServiceProvider:/").splitlines();
  if len(auditServiceProviders) > 0:
    for auditServiceProvider in auditServiceProviders:
      if len(auditServiceProvider) > 0:
        auditServiceProviderName = Util.getRequiredAttribute(auditServiceProvider, "name", "AuditServiceProvider" );
        
        if (name == auditServiceProviderName):
          auditServiceProviderId = auditServiceProvider;
          break;
  
  if auditServiceProviderId is None or len(auditServiceProviderId) < 1:
    raise Exception("Could not find audit service provider named %(name)s" % { 'name':name } );

  properties = [];
  properties.append([parentAtt, auditServiceProviderId]);
  Log.debug(properties);
  Log.debug(parentid);
  print "Creating AuditServiceProviderRef to %(id)s for attribute %(att)s" % { 'id':auditServiceProviderId, 'att':parentAtt };
  objid = Util.modify(parentid, properties);
  Log.debug("Finished Creating AuditServiceProviderRef to %(id)s for attribute %(att)s" % { 'id':auditServiceProviderId, 'att':parentAtt });
  Util.popPathElement('AuditServiceProviderRef');
