from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JSR160RMIConnector')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJSR160RMIConnector");
  exportedObject.put("roleName", "WebSphereJSR160RMIConnector");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jsr160rmiconnector.enable", objid, "enable","JSR160RMIConnector");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"JSR160RMIConnector");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JSR160RMIConnector');
  return result;



def create(parentid, jsonobject, attname = None):
  Util.pushPathElement('JSR160RMIConnector')
  if not jsonobject.has("roleProperties"):
    raise Exception("JSR160RMIConnector resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.jsr160rmiconnector.enable", None));
  print "Creating JSR160RMIConnector with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

  if attname is None or len(attname) == 0:
    objid = Util.create("JSR160RMIConnector", parentid, properties);
  else:
    objid = Util.create("JSR160RMIConnector", parentid, properties, attname);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JSR160RMIConnector');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('JSR160RMIConnector')
  if not jsonobject.has("roleProperties"):
    raise Exception("JSR160RMIConnector resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jsr160rmiconnector.enable", None), "enable","JSR160RMIConnector");
  if len(atts) != 0:
    print "Modifying JSR160RMIConnector with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JSR160RMIConnector configuration up to date.";

  Property.removeProperties(objid, 'properties',"JSR160RMIConnector");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JSR160RMIConnector');
