from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.rewritingactionref.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RewritingActionRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "name", "RewritingAction");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered RewritingActionRef");
  exportedObject.put("roleName", "WebSphereRewritingActionRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rewritingactionref.name", objid, "name","RewritingAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RewritingActionRef');
  return result;


def doImport(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WebSphereRewritingActionRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.rewritingactionref.name"):
    raise Exception("Resource role properties does not contain websphere.rewritingactionref.name!");

  rewritingActionRefName = roleProperties.optString("websphere.rewritingactionref.name", None);
  serverName = parentid.split('/servers/')[1].split('|')[0];
  if serverName == None or len(serverName) == 0:
    clusterName = parentid.split('/clusters/')[1].split('|')[0];
    containmentPath = "/ServerCluster:" + clusterName + "/ProxyVirtualHostConfig:/RewritingAction:" + rewritingActionRefName + "/";
  else:
    containmentPath = "/Server:" + serverName + "/ProxyVirtualHostConfig:/RewritingAction:" + rewritingActionRefName + "/";
  rewritingAction = Util.getid(containmentPath);
  if rewritingAction == None or len(rewritingAction) == 0:
      raise Exception("Could not determine the Rewriting Action for RewritingActionRef " + rewritingActionRefName + ". Searched on containment path " + containmentPath + ".");

  Util.pushPathElement("Server");
  Util.pushPathElement("ProxyVirtualHostConfig");
  Util.pushPathElement("ProxyRuleExpression");
  Util.modify(parentid, [['enabledProxyActions', rewritingAction]]);
  Util.popPathElement("ProxyRuleExpression");
  Util.popPathElement("ProxyVirtualHostConfig");
  Util.popPathElement("Server");
