from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBContextInfo')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBContextInfo");
  exportedObject.put("roleName", "WebSphereSIBContextInfo");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibcontextinfo.name", objid, "name","SIBContextInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibcontextinfo.type", objid, "type","SIBContextInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibcontextinfo.value", objid, "value","SIBContextInfo");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBContextInfo');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBContextInfo')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBContextInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibcontextinfo.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.sibcontextinfo.type", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.sibcontextinfo.value", None));
  print "Creating SIBContextInfo with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBContextInfo", parentid, properties);
  Util.popPathElement('SIBContextInfo');

def update(objid,jsonobject):
  Util.pushPathElement('SIBContextInfo')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBContextInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibcontextinfo.name", None), "name","SIBContextInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibcontextinfo.type", None), "type","SIBContextInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibcontextinfo.value", None), "value","SIBContextInfo");
  if len(atts) != 0:
    print "Modifying SIBContextInfo with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBContextInfo configuration up to date.";

  Util.popPathElement('SIBContextInfo');
