from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMediationInstance')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMediationInstance");
  exportedObject.put("roleName", "WebSphereSIBMediationInstance");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationinstance.initialstate", objid, "initialState","SIBMediationInstance");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmediationinstance.mediationrefuuid", objid, "mediationRefUuid","SIBMediationInstance");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMediationInstance');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMediationInstance')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMediationInstance resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "initialState", roleProperties.optString("websphere.sibmediationinstance.initialstate", None));
  Util.addIfNotNone(properties, "mediationRefUuid", roleProperties.optString("websphere.sibmediationinstance.mediationrefuuid", None));
  print "Creating SIBMediationInstance with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMediationInstance", parentid, properties);
  Util.popPathElement('SIBMediationInstance');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMediationInstance')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMediationInstance resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationinstance.initialstate", None), "initialState","SIBMediationInstance");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmediationinstance.mediationrefuuid", None), "mediationRefUuid","SIBMediationInstance");
  if len(atts) != 0:
    print "Modifying SIBMediationInstance with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMediationInstance configuration up to date.";

  Util.popPathElement('SIBMediationInstance');
