from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBLinkRef import SIBLinkRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBVirtualMQLink')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBVirtualMQLink");
  exportedObject.put("roleName", "WebSphereSIBVirtualMQLink");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibvirtualmqlink.inbounduserid", objid, "inboundUserid","SIBVirtualMQLink");
  # default name from WebSphere contains a colon, which WebSphere does not accept when manually creating/updating
  name = Util.getRequiredAttribute(objid, "name", 'SIBVirtualMQLink');
  name = Util.replaceColonWithDash(name);
  Util.addToJsonIfNotNone(roleProperties, 'websphere.sibvirtualmqlink.name', name);
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibvirtualmqlink.uuid", objid, "uuid","SIBVirtualMQLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibvirtualmqlink.outbounduserid", objid, "outboundUserid","SIBVirtualMQLink");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  linkRefs = Util.parseConfigIdListAttribute(objid, 'linkRef',"SIBVirtualMQLink");
  for linkRef in linkRefs:
    if len(linkRef) > 0:
      returndict = Util.createTypeFolder(respath, "SIBLinkRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      linkRefName = Util.getRequiredAttribute(linkRef, "name", "SIBLinkRef");
      Util.addAllFromExport(extraObjects, SIBLinkRef._export(linkRef, currespath, linkRefName));
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBVirtualMQLink');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBVirtualMQLink')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBVirtualMQLink resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inboundUserid", roleProperties.optString("websphere.sibvirtualmqlink.inbounduserid", None));
  Util.addIfNotNone(properties, "name", Util.replaceColonWithDash(roleProperties.optString("websphere.sibvirtualmqlink.name", None)));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibvirtualmqlink.uuid", None));
  Util.addIfNotNone(properties, "outboundUserid", roleProperties.optString("websphere.sibvirtualmqlink.outbounduserid", None));
  print "Creating SIBVirtualMQLink with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBVirtualMQLink", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBLinkRef":
        SIBLinkRef.create(objid, curjsonobject);
  Util.popPathElement('SIBVirtualMQLink');

def update(objid,jsonobject):
  Util.pushPathElement('SIBVirtualMQLink')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBVirtualMQLink resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibvirtualmqlink.inbounduserid", None), "inboundUserid","SIBVirtualMQLink");
  Util.addAttIfChanged(objid, atts, Util.replaceColonWithDash(roleProperties.optString("websphere.sibvirtualmqlink.name", None)), "name","SIBVirtualMQLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibvirtualmqlink.uuid", None), "uuid","SIBVirtualMQLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibvirtualmqlink.outbounduserid", None), "outboundUserid","SIBVirtualMQLink");
  if len(atts) != 0:
    print "Modifying SIBVirtualMQLink with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBVirtualMQLink configuration up to date.";

  linkRefs = Util.parseConfigIdListAttribute(objid, 'linkRef',"SIBVirtualMQLink");
  for linkRef in linkRefs:
    if len(linkRef) > 0:
      Util.remove(linkRef);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBLinkRef":
        SIBLinkRef.create(objid, curjsonobject);

  Util.popPathElement('SIBVirtualMQLink');
