from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWMQServerEndpoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWMQServerEndpoint");
  exportedObject.put("roleName", "WebSphereSIBWMQServerEndpoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserverendpoint.port", objid, "port","SIBWMQServerEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwmqserverendpoint.host", objid, "host","SIBWMQServerEndpoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWMQServerEndpoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWMQServerEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWMQServerEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.sibwmqserverendpoint.port", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.sibwmqserverendpoint.host", None));
  print "Creating SIBWMQServerEndpoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWMQServerEndpoint", parentid, properties);
  Util.popPathElement('SIBWMQServerEndpoint');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWMQServerEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWMQServerEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserverendpoint.port", None), "port","SIBWMQServerEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwmqserverendpoint.host", None), "host","SIBWMQServerEndpoint");
  if len(atts) != 0:
    print "Modifying SIBWMQServerEndpoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWMQServerEndpoint configuration up to date.";

  Util.popPathElement('SIBWMQServerEndpoint');
