from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.sslinboundchannel.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'SSLInboundChannel');

  containmentpath = "%(parentconpath)sSSLInboundChannel:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('SSLInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'SSLInboundChannel');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSSLInboundChannel");
  exportedObject.put("roleName", "WebSphereSSLInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sslinboundchannel.name", objid, "name","SSLInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sslinboundchannel.discriminationweight", objid, "discriminationWeight","SSLInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sslinboundchannel.sslconfigalias", objid, "sslConfigAlias","SSLInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SSLInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SSLInboundChannel');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("SSLInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.sslinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.sslinboundchannel.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create SSLInboundChannel on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('SSLInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SSLInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.sslinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.sslinboundchannel.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sslinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.sslinboundchannel.discriminationweight", None));
  Util.addIfNotNone(properties, "sslConfigAlias", roleProperties.optString("websphere.sslinboundchannel.sslconfigalias", None));
  print "Creating SSLInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SSLInboundChannel", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SSLInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('SSLInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SSLInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.sslinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.sslinboundchannel.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sslinboundchannel.name", None), "name","SSLInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sslinboundchannel.discriminationweight", None), "discriminationWeight","SSLInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sslinboundchannel.sslconfigalias", None), "sslConfigAlias","SSLInboundChannel");
  if len(atts) != 0:
    print "Modifying SSLInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SSLInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"SSLInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('SSLInboundChannel');
