from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('UserExt')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereUserExt");
  exportedObject.put("roleName", "WebSphereUserExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userext.name", objid, "name","UserExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userext.accessid", objid, "accessId","UserExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('UserExt');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('UserExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("UserExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.userext.name", None));
  Util.addIfNotNone(properties, "accessId", roleProperties.optString("websphere.userext.accessid", None));
  print "Creating UserExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("UserExt", parentid, properties);
  Util.popPathElement('UserExt');

def update(objid,jsonobject):
  Util.pushPathElement('UserExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("UserExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userext.name", None), "name","UserExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userext.accessid", None), "accessId","UserExt");
  if len(atts) != 0:
    print "Modifying UserExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "UserExt configuration up to date.";

  Util.popPathElement('UserExt');
