from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DPFirmware')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDPFirmware");
  exportedObject.put("roleName", "WebSphereDPFirmware");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmware.nonstrictfeatures", objid, "nonstrictFeatures","DPFirmware");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmware.highestversion", objid, "highestVersion","DPFirmware");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmware.strictfeatures", objid, "strictFeatures","DPFirmware");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmware.modeltype", objid, "modelType","DPFirmware");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmware.devicetype", objid, "deviceType","DPFirmware");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DPFirmware");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DPFirmware');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DPFirmware')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPFirmware resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "nonstrictFeatures", roleProperties.optString("websphere.dpfirmware.nonstrictfeatures", None));
  Util.addIfNotNone(properties, "highestVersion", roleProperties.optString("websphere.dpfirmware.highestversion", None));
  Util.addIfNotNone(properties, "strictFeatures", roleProperties.optString("websphere.dpfirmware.strictfeatures", None));
  Util.addIfNotNone(properties, "modelType", roleProperties.optString("websphere.dpfirmware.modeltype", None));
  Util.addIfNotNone(properties, "deviceType", roleProperties.optString("websphere.dpfirmware.devicetype", None));
  print "Creating DPFirmware with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DPFirmware", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPFirmware');

def update(objid,jsonobject):
  Util.pushPathElement('DPFirmware')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPFirmware resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmware.nonstrictfeatures", None), "nonstrictFeatures","DPFirmware");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmware.highestversion", None), "highestVersion","DPFirmware");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmware.strictfeatures", None), "strictFeatures","DPFirmware");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmware.modeltype", None), "modelType","DPFirmware");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmware.devicetype", None), "deviceType","DPFirmware");
  if len(atts) != 0:
    print "Modifying DPFirmware with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DPFirmware configuration up to date.";

  Property.removeProperties(objid, 'properties',"DPFirmware");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPFirmware');
