from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from ThreadPool import ThreadPool
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HAManagerService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHAManagerService");
  exportedObject.put("roleName", "WebSphereHAManagerService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hamanagerservice.activateenabled", objid, "activateEnabled","HAManagerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hamanagerservice.enable", objid, "enable","HAManagerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hamanagerservice.transportbuffersize", objid, "transportBufferSize","HAManagerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hamanagerservice.coregroupname", objid, "coreGroupName","HAManagerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hamanagerservice.description", objid, "description","HAManagerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hamanagerservice.isaliveperiodsec", objid, "isAlivePeriodSec","HAManagerService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"HAManagerService");

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'HAManagerService');
  if threadPool is not None and len(threadPool) > 0:
    returndict = Util.createTypeFolder(respath, "ThreadPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ThreadPool._export(threadPool, currespath));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HAManagerService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('HAManagerService')
  if not jsonobject.has("roleProperties"):
    raise Exception("HAManagerService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "activateEnabled", roleProperties.optString("websphere.hamanagerservice.activateenabled", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.hamanagerservice.enable", None));
  Util.addIfNotNone(properties, "transportBufferSize", roleProperties.optString("websphere.hamanagerservice.transportbuffersize", None));
  Util.addIfNotNone(properties, "coreGroupName", roleProperties.optString("websphere.hamanagerservice.coregroupname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.hamanagerservice.description", None));
  Util.addIfNotNone(properties, "isAlivePeriodSec", roleProperties.optString("websphere.hamanagerservice.isaliveperiodsec", None));
  print "Creating HAManagerService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HAManagerService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereThreadPool":
          ThreadPool.create(objid, curjsonobject);
  Util.popPathElement('HAManagerService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('HAManagerService')
  if not jsonobject.has("roleProperties"):
    raise Exception("HAManagerService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hamanagerservice.activateenabled", None), "activateEnabled","HAManagerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hamanagerservice.enable", None), "enable","HAManagerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hamanagerservice.transportbuffersize", None), "transportBufferSize","HAManagerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hamanagerservice.coregroupname", None), "coreGroupName","HAManagerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hamanagerservice.description", None), "description","HAManagerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hamanagerservice.isaliveperiodsec", None), "isAlivePeriodSec","HAManagerService");
  if len(atts) != 0:
    print "Modifying HAManagerService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HAManagerService configuration up to date.";

  Property.removeProperties(objid, 'properties',"HAManagerService");

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'HAManagerService');
  if threadPool is not None and len(threadPool) > 0:
    Util.remove(threadPool);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereThreadPool":
          ThreadPool.create(objid, curjsonobject);
  Util.popPathElement('HAManagerService');
