from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PMIService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePMIService");
  exportedObject.put("roleName", "WebSpherePMIService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmiservice.synchronizedupdate", objid, "synchronizedUpdate","PMIService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmiservice.enable", objid, "enable","PMIService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmiservice.statisticset", objid, "statisticSet","PMIService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmiservice.initialspeclevel", objid, "initialSpecLevel","PMIService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"PMIService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PMIService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('PMIService')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMIService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "synchronizedUpdate", roleProperties.optString("websphere.pmiservice.synchronizedupdate", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.pmiservice.enable", None));
  Util.addIfNotNone(properties, "statisticSet", roleProperties.optString("websphere.pmiservice.statisticset", None));
  Util.addIfNotNone(properties, "initialSpecLevel", roleProperties.optString("websphere.pmiservice.initialspeclevel", None));
  print "Creating PMIService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PMIService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('PMIService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('PMIService')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMIService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmiservice.synchronizedupdate", None), "synchronizedUpdate","PMIService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmiservice.enable", None), "enable","PMIService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmiservice.statisticset", None), "statisticSet","PMIService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmiservice.initialspeclevel", None), "initialSpecLevel","PMIService");
  if len(atts) != 0:
    print "Modifying PMIService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PMIService configuration up to date.";

  Property.removeProperties(objid, 'properties',"PMIService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('PMIService');
