from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.routingactionref.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RoutingActionRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "name", "RoutingAction");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRoutingActionRef");
  exportedObject.put("roleName", "WebSphereRoutingActionRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.routingactionref.name", objid, "name","RoutingAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RoutingActionRef');
  return result;


def doImport(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WebSphereRoutingActionRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.routingactionref.name"):
    raise Exception("Resource role properties does not contain websphere.proxyactionref.name!");

  routingActionRefName = roleProperties.optString("websphere.routingactionref.name", None);
  serverName = parentid.split('/servers/')[1].split('|')[0];
  if serverName == None or len(serverName) == 0:
    clusterName = parentid.split('/clusters/')[1].split('|')[0];
    containmentPath = "/ServerCluster:" + clusterName + "/ProxyVirtualHostConfig:/RoutingAction:" + routingActionRefName + "/";
  else:
    containmentPath = "/Server:" + serverName + "/ProxyVirtualHostConfig:/RoutingAction:" + routingActionRefName + "/";
  routingAction = Util.getid(containmentPath);
  if routingAction == None or len(routingAction) == 0:
      raise Exception("Could not determine the Routing Action for RoutingActionRef " + routingActionRefName + ". Searched on containment path " + containmentPath + ".");

  Util.pushPathElement("Server");
  Util.pushPathElement("ProxyVirtualHostConfig");
  Util.pushPathElement("ProxyRuleExpression");
  Util.modify(parentid, [['enabledProxyActions', routingAction]]);
  Util.popPathElement("ProxyRuleExpression");
  Util.popPathElement("ProxyVirtualHostConfig");
  Util.popPathElement("Server");
