from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.rules.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'Rules');

  containmentpath = "%(parentconpath)sRules:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('Rules')

  name = Util.getRequiredAttribute(objid, "name", 'Rules');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRules");
  exportedObject.put("roleName", "WebSphereRules");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rules.name", objid, "name","Rules");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rules.matchaction", objid, "matchAction","Rules");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Rules');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("Rules resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.rules.name"):
    raise Exception("Resource role properties does not contain websphere.rules.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create Rules on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('Rules')
  if not jsonobject.has("roleProperties"):
    raise Exception("Rules resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.rules.name"):
    raise Exception("Resource role properties does not contain websphere.rules.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.rules.name", None));
  Util.addIfNotNone(properties, "matchAction", roleProperties.optString("websphere.rules.matchaction", None));
  print "Creating Rules with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Rules", parentid, properties);
  Util.popPathElement('Rules');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('Rules')
  if not jsonobject.has("roleProperties"):
    raise Exception("Rules resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.rules.name"):
    raise Exception("Resource role properties does not contain websphere.rules.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rules.name", None), "name","Rules");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rules.matchaction", None), "matchAction","Rules");
  if len(atts) != 0:
    print "Modifying Rules with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Rules configuration up to date.";

  Util.popPathElement('Rules');
