from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQClientLinkAdvancedProperties')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQClientLinkAdvancedProperties");
  exportedObject.put("roleName", "WebSphereSIBMQClientLinkAdvancedProperties");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.inboundnonpersistentreliability", objid, "inboundNonPersistentReliability","SIBMQClientLinkAdvancedProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.brokerccdursubq", objid, "brokerCCDurSubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.brokerccsubq", objid, "brokerCCSubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.brokerconq", objid, "brokerConQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.brokerdursubq", objid, "brokerDurSubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.brokerpubq", objid, "brokerPubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.inboundpersistentreliability", objid, "inboundPersistentReliability","SIBMQClientLinkAdvancedProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.brokersubq", objid, "brokerSubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlinkadvancedproperties.defaulttopicspace", objid, "defaultTopicSpace","SIBMQClientLinkAdvancedProperties");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQClientLinkAdvancedProperties');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQClientLinkAdvancedProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQClientLinkAdvancedProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inboundNonPersistentReliability", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.inboundnonpersistentreliability", None));
  Util.addIfNotNone(properties, "brokerCCDurSubQ", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerccdursubq", None));
  Util.addIfNotNone(properties, "brokerCCSubQ", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerccsubq", None));
  Util.addIfNotNone(properties, "brokerConQ", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerconq", None));
  Util.addIfNotNone(properties, "brokerDurSubQ", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerdursubq", None));
  Util.addIfNotNone(properties, "brokerPubQ", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerpubq", None));
  Util.addIfNotNone(properties, "inboundPersistentReliability", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.inboundpersistentreliability", None));
  Util.addIfNotNone(properties, "brokerSubQ", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokersubq", None));
  Util.addIfNotNone(properties, "defaultTopicSpace", roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.defaulttopicspace", None));
  print "Creating SIBMQClientLinkAdvancedProperties with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQClientLinkAdvancedProperties", parentid, properties);
  Util.popPathElement('SIBMQClientLinkAdvancedProperties');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQClientLinkAdvancedProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQClientLinkAdvancedProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.inboundnonpersistentreliability", None), "inboundNonPersistentReliability","SIBMQClientLinkAdvancedProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerccdursubq", None), "brokerCCDurSubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerccsubq", None), "brokerCCSubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerconq", None), "brokerConQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerdursubq", None), "brokerDurSubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokerpubq", None), "brokerPubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.inboundpersistentreliability", None), "inboundPersistentReliability","SIBMQClientLinkAdvancedProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.brokersubq", None), "brokerSubQ","SIBMQClientLinkAdvancedProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlinkadvancedproperties.defaulttopicspace", None), "defaultTopicSpace","SIBMQClientLinkAdvancedProperties");
  if len(atts) != 0:
    print "Modifying SIBMQClientLinkAdvancedProperties with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQClientLinkAdvancedProperties configuration up to date.";

  Util.popPathElement('SIBMQClientLinkAdvancedProperties');
