from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PluginServerClusterProperties')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePluginServerClusterProperties");
  exportedObject.put("roleName", "WebSpherePluginServerClusterProperties");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginserverclusterproperties.retryinterval", objid, "RetryInterval","PluginServerClusterProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginserverclusterproperties.postsizelimit", objid, "PostSizeLimit","PluginServerClusterProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginserverclusterproperties.postbuffersize", objid, "PostBufferSize","PluginServerClusterProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginserverclusterproperties.loadbalance", objid, "LoadBalance","PluginServerClusterProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginserverclusterproperties.cloneseparatorchange", objid, "CloneSeparatorChange","PluginServerClusterProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginserverclusterproperties.removespecialheaders", objid, "RemoveSpecialHeaders","PluginServerClusterProperties");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PluginServerClusterProperties');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PluginServerClusterProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("PluginServerClusterProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "RetryInterval", roleProperties.optString("websphere.pluginserverclusterproperties.retryinterval", None));
  Util.addIfNotNone(properties, "PostSizeLimit", roleProperties.optString("websphere.pluginserverclusterproperties.postsizelimit", None));
  Util.addIfNotNone(properties, "PostBufferSize", roleProperties.optString("websphere.pluginserverclusterproperties.postbuffersize", None));
  Util.addIfNotNone(properties, "LoadBalance", roleProperties.optString("websphere.pluginserverclusterproperties.loadbalance", None));
  Util.addIfNotNone(properties, "CloneSeparatorChange", roleProperties.optString("websphere.pluginserverclusterproperties.cloneseparatorchange", None));
  Util.addIfNotNone(properties, "RemoveSpecialHeaders", roleProperties.optString("websphere.pluginserverclusterproperties.removespecialheaders", None));
  print "Creating PluginServerClusterProperties with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PluginServerClusterProperties", parentid, properties);
  Util.popPathElement('PluginServerClusterProperties');

def update(objid,jsonobject):
  Util.pushPathElement('PluginServerClusterProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("PluginServerClusterProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginserverclusterproperties.retryinterval", None), "RetryInterval","PluginServerClusterProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginserverclusterproperties.postsizelimit", None), "PostSizeLimit","PluginServerClusterProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginserverclusterproperties.postbuffersize", None), "PostBufferSize","PluginServerClusterProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginserverclusterproperties.loadbalance", None), "LoadBalance","PluginServerClusterProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginserverclusterproperties.cloneseparatorchange", None), "CloneSeparatorChange","PluginServerClusterProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginserverclusterproperties.removespecialheaders", None), "RemoveSpecialHeaders","PluginServerClusterProperties");
  if len(atts) != 0:
    print "Modifying PluginServerClusterProperties with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PluginServerClusterProperties configuration up to date.";

  Util.popPathElement('PluginServerClusterProperties');
