from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from SecurityDomain import SecurityDomain

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Policy')

  policyName = Util.getOptionalAttribute(objid, "name", 'Policy');
  if policyName is not None and len(policyName) > 0:
    name = policyName;

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePolicy");
  exportedObject.put("roleName", "WebSpherePolicy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.policy.name", objid, "name","Policy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Policy");

  securityDomainList = SecurityDomain.getSecurityDomains(objid);
  for securityDomain in securityDomainList:
    if len(securityDomain) > 0:
      returndict = Util.createTypeFolder(respath, "SecurityDomain", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SecurityDomain._export(securityDomain, currespath));  

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Policy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Policy')
  if not jsonobject.has("roleProperties"):
    raise Exception("Policy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.policy.name", None));
  print "Creating Policy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Policy", parentid, properties);
  
  securityDomainList = SecurityDomain.getSecurityDomains(objid);
  for securityDomain in securityDomainList:
    if len(securityDomain) > 0:
      Util.remove(securityDomain);  
  
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereSecurityDomain":
          SecurityDomain.create(objid, curjsonobject);
  Util.popPathElement('Policy');
      
def update(objid,jsonobject):
  Util.pushPathElement('Policy')
  if not jsonobject.has("roleProperties"):
    raise Exception("Policy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.policy.name", None), "name","Policy");
  if len(atts) != 0:
    print "Modifying Policy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Policy configuration up to date.";

  Property.removeProperties(objid, 'properties',"Policy");

  securityDomainList = SecurityDomain.getSecurityDomains(objid);
  for securityDomain in securityDomainList:
    if len(securityDomain) > 0:
      Util.remove(securityDomain);    
  
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereSecurityDomain":
          SecurityDomain.create(objid, curjsonobject);      
  Util.popPathElement('Policy');
