from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSSecurityRequestGeneratorBindingConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSSecurityRequestGeneratorBindingConfig");
  exportedObject.put("roleName", "WebSphereSIBWSSecurityRequestGeneratorBindingConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwssecurityrequestgeneratorbindingconfig.name", objid, "name","SIBWSSecurityRequestGeneratorBindingConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSSecurityRequestGeneratorBindingConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSSecurityRequestGeneratorBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityRequestGeneratorBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwssecurityrequestgeneratorbindingconfig.name", None));
  print "Creating SIBWSSecurityRequestGeneratorBindingConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSSecurityRequestGeneratorBindingConfig", parentid, properties);
  Util.popPathElement('SIBWSSecurityRequestGeneratorBindingConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSSecurityRequestGeneratorBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityRequestGeneratorBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwssecurityrequestgeneratorbindingconfig.name", None), "name","SIBWSSecurityRequestGeneratorBindingConfig");
  if len(atts) != 0:
    print "Modifying SIBWSSecurityRequestGeneratorBindingConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSSecurityRequestGeneratorBindingConfig configuration up to date.";

  Util.popPathElement('SIBWSSecurityRequestGeneratorBindingConfig');
