from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TransactionService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTransactionService");
  exportedObject.put("roleName", "WebSphereTransactionService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.httpproxyprefix", objid, "httpProxyPrefix","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.transactionlogdirectory", objid, "transactionLogDirectory","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.propogatedorbmttranlifetimetimeout", objid, "propogatedOrBMTTranLifetimeTimeout","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.asyncresponsetimeout", objid, "asyncResponseTimeout","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.maximumtransactiontimeout", objid, "maximumTransactionTimeout","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.acceptheuristichazard", objid, "acceptHeuristicHazard","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.wstxurlprefixspecified", objid, "wstxURLPrefixSpecified","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.waitforcommitoutcome", objid, "waitForCommitOutcome","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.totaltranlifetimetimeout", objid, "totalTranLifetimeTimeout","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.heuristicretrylimit", objid, "heuristicRetryLimit","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.enable", objid, "enable","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.enablefilelocking", objid, "enableFileLocking","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.enableloggingforheuristicreporting", objid, "enableLoggingForHeuristicReporting","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.wstransactionspecificationlevel", objid, "WSTransactionSpecificationLevel","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.heuristicretrywait", objid, "heuristicRetryWait","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.httpsproxyprefix", objid, "httpsProxyPrefix","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.lpsheuristiccompletion", objid, "LPSHeuristicCompletion","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.clientinactivitytimeout", objid, "clientInactivityTimeout","TransactionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionservice.enableprotocolsecurity", objid, "enableProtocolSecurity","TransactionService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"TransactionService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TransactionService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('TransactionService')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransactionService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "httpProxyPrefix", roleProperties.optString("websphere.transactionservice.httpproxyprefix", None));
  Util.addIfNotNone(properties, "transactionLogDirectory", roleProperties.optString("websphere.transactionservice.transactionlogdirectory", None));
  Util.addIfNotNone(properties, "propogatedOrBMTTranLifetimeTimeout", roleProperties.optString("websphere.transactionservice.propogatedorbmttranlifetimetimeout", None));
  Util.addIfNotNone(properties, "asyncResponseTimeout", roleProperties.optString("websphere.transactionservice.asyncresponsetimeout", None));
  Util.addIfNotNone(properties, "maximumTransactionTimeout", roleProperties.optString("websphere.transactionservice.maximumtransactiontimeout", None));
  Util.addIfNotNone(properties, "acceptHeuristicHazard", roleProperties.optString("websphere.transactionservice.acceptheuristichazard", None));
  Util.addIfNotNone(properties, "wstxURLPrefixSpecified", roleProperties.optString("websphere.transactionservice.wstxurlprefixspecified", None));
  Util.addIfNotNone(properties, "waitForCommitOutcome", roleProperties.optString("websphere.transactionservice.waitforcommitoutcome", None));
  Util.addIfNotNone(properties, "totalTranLifetimeTimeout", roleProperties.optString("websphere.transactionservice.totaltranlifetimetimeout", None));
  Util.addIfNotNone(properties, "heuristicRetryLimit", roleProperties.optString("websphere.transactionservice.heuristicretrylimit", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.transactionservice.enable", None));
  Util.addIfNotNone(properties, "enableFileLocking", roleProperties.optString("websphere.transactionservice.enablefilelocking", None));
  Util.addIfNotNone(properties, "enableLoggingForHeuristicReporting", roleProperties.optString("websphere.transactionservice.enableloggingforheuristicreporting", None));
  Util.addIfNotNone(properties, "WSTransactionSpecificationLevel", roleProperties.optString("websphere.transactionservice.wstransactionspecificationlevel", None));
  Util.addIfNotNone(properties, "heuristicRetryWait", roleProperties.optString("websphere.transactionservice.heuristicretrywait", None));
  Util.addIfNotNone(properties, "httpsProxyPrefix", roleProperties.optString("websphere.transactionservice.httpsproxyprefix", None));
  Util.addIfNotNone(properties, "LPSHeuristicCompletion", roleProperties.optString("websphere.transactionservice.lpsheuristiccompletion", None));
  Util.addIfNotNone(properties, "clientInactivityTimeout", roleProperties.optString("websphere.transactionservice.clientinactivitytimeout", None));
  Util.addIfNotNone(properties, "enableProtocolSecurity", roleProperties.optString("websphere.transactionservice.enableprotocolsecurity", None));
  print "Creating TransactionService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TransactionService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TransactionService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('TransactionService')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransactionService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.httpproxyprefix", None), "httpProxyPrefix","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.transactionlogdirectory", None), "transactionLogDirectory","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.propogatedorbmttranlifetimetimeout", None), "propogatedOrBMTTranLifetimeTimeout","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.asyncresponsetimeout", None), "asyncResponseTimeout","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.maximumtransactiontimeout", None), "maximumTransactionTimeout","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.acceptheuristichazard", None), "acceptHeuristicHazard","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.wstxurlprefixspecified", None), "wstxURLPrefixSpecified","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.waitforcommitoutcome", None), "waitForCommitOutcome","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.totaltranlifetimetimeout", None), "totalTranLifetimeTimeout","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.heuristicretrylimit", None), "heuristicRetryLimit","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.enable", None), "enable","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.enablefilelocking", None), "enableFileLocking","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.enableloggingforheuristicreporting", None), "enableLoggingForHeuristicReporting","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.wstransactionspecificationlevel", None), "WSTransactionSpecificationLevel","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.heuristicretrywait", None), "heuristicRetryWait","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.httpsproxyprefix", None), "httpsProxyPrefix","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.lpsheuristiccompletion", None), "LPSHeuristicCompletion","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.clientinactivitytimeout", None), "clientInactivityTimeout","TransactionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionservice.enableprotocolsecurity", None), "enableProtocolSecurity","TransactionService");
  if len(atts) != 0:
    print "Modifying TransactionService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TransactionService configuration up to date.";

  Property.removeProperties(objid, 'properties',"TransactionService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TransactionService');
