from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationServerMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationServerMapping");
  exportedObject.put("roleName", "WebSphereApplicationServerMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationservermapping.applicationname", objid, "applicationName","ApplicationServerMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationservermapping.cellname", objid, "cellName","ApplicationServerMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationservermapping.transportchain", objid, "transportChain","ApplicationServerMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationServerMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ApplicationServerMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "applicationName", roleProperties.optString("websphere.applicationservermapping.applicationname", None));
  Util.addIfNotNone(properties, "cellName", roleProperties.optString("websphere.applicationservermapping.cellname", None));
  Util.addIfNotNone(properties, "transportChain", roleProperties.optString("websphere.applicationservermapping.transportchain", None));
  print "Creating ApplicationServerMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationServerMapping", parentid, properties);
  Util.popPathElement('ApplicationServerMapping');

def update(objid,jsonobject):
  Util.pushPathElement('ApplicationServerMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationservermapping.applicationname", None), "applicationName","ApplicationServerMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationservermapping.cellname", None), "cellName","ApplicationServerMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationservermapping.transportchain", None), "transportChain","ApplicationServerMapping");
  if len(atts) != 0:
    print "Modifying ApplicationServerMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationServerMapping configuration up to date.";

  Util.popPathElement('ApplicationServerMapping');
