from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DRSSettings')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDRSSettings");
  exportedObject.put("roleName", "WebSphereDRSSettings");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.drssettings.overridehostconnectionpoints", objid, "overrideHostConnectionPoints","DRSSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drssettings.messagebrokerdomainname", objid, "messageBrokerDomainName","DRSSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drssettings.datareplicationmode", objid, "dataReplicationMode","DRSSettings");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drssettings.preferredlocaldrsbrokername", objid, "preferredLocalDRSBrokerName","DRSSettings");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];

  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DRSSettings");

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DRSSettings');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DRSSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("DRSSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "overrideHostConnectionPoints", roleProperties.optString("websphere.drssettings.overridehostconnectionpoints", None));
  Util.addIfNotNone(properties, "messageBrokerDomainName", roleProperties.optString("websphere.drssettings.messagebrokerdomainname", None));
  Util.addIfNotNone(properties, "dataReplicationMode", roleProperties.optString("websphere.drssettings.datareplicationmode", None));
  Util.addIfNotNone(properties, "preferredLocalDRSBrokerName", roleProperties.optString("websphere.drssettings.preferredlocaldrsbrokername", None));
  print "Creating DRSSettings with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DRSSettings", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DRSSettings');

def update(objid,jsonobject):
  Util.pushPathElement('DRSSettings')
  if not jsonobject.has("roleProperties"):
    raise Exception("DRSSettings resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.drssettings.overridehostconnectionpoints", None), "overrideHostConnectionPoints","DRSSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drssettings.messagebrokerdomainname", None), "messageBrokerDomainName","DRSSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drssettings.datareplicationmode", None), "dataReplicationMode","DRSSettings");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drssettings.preferredlocaldrsbrokername", None), "preferredLocalDRSBrokerName","DRSSettings");
  if len(atts) != 0:
    print "Modifying DRSSettings with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DRSSettings configuration up to date.";

  Property.removeProperties(objid,'properties',"DRSSettings");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('DRSSettings');
