from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('KeyStoreFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereKeyStoreFile");
  exportedObject.put("roleName", "WebSphereKeyStoreFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keystorefile.directory", objid, "directory","KeyStoreFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keystorefile.name", objid, "name","KeyStoreFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('KeyStoreFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('KeyStoreFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("KeyStoreFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "directory", roleProperties.optString("websphere.keystorefile.directory", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.keystorefile.name", None));
  print "Creating KeyStoreFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("KeyStoreFile", parentid, properties);
  Util.popPathElement('KeyStoreFile');

def update(objid,jsonobject):
  Util.pushPathElement('KeyStoreFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("KeyStoreFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keystorefile.directory", None), "directory","KeyStoreFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keystorefile.name", None), "name","KeyStoreFile");
  if len(atts) != 0:
    print "Modifying KeyStoreFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "KeyStoreFile configuration up to date.";

  Util.popPathElement('KeyStoreFile');
